defmodule MyProject.Repo.Migrations.ItemsSearch do
  use Ecto.Migration

  def up do
    execute "CREATE EXTENSION IF NOT EXISTS pg_trgm;"

    execute """
    CREATE INDEX items_search_index
    ON items
    USING gin ((name) gin_trgm_ops);
    """
  end

  def down do
    execute """
    DROP INDEX IF EXISTS items_search_index;
    """

    execute "DROP EXTENSION IF EXISTS pg_trgm;"
  end
end