import {LitElement, unsafeCSS} from 'lit'
import type {ViewHook} from 'phoenix_live_view'
import styles from '../../../priv/static/assets/app.css?inline'

declare global {
  interface HTMLElement {
    LitLiveHook?: ViewHook
  }
}

export default class LitLiveElement extends LitElement {
  static styles = [unsafeCSS(styles)]
  LitLiveHook?: ViewHook
}

export const LitLiveHook = {
  mounted(this: ViewHook) {
    this.el.LitLiveHook = this
  },
} satisfies Partial<ViewHook>